<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.276.0.76.3.1.195.10.9
Name: Geburtsjahr des Patienten
Description: Geburtsjahr des Patienten, abgeleitet aus Geburtsdatum
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044">
   <title>Geburtsjahr des Patienten</title>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]
Item: (Geburtsjahr des Patienten)
-->

   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]"
         id="d45e9270-false-d27759e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="string(@classCode) = ('OBS')">(Geburtsjahr des Patienten): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="string(@moodCode) = ('EVN')">(Geburtsjahr des Patienten): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']) &gt;= 1">(Geburtsjahr des Patienten): Element hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:code[(@code = '80904-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Geburtsjahr des Patienten): Element hl7:code[(@code = '80904-6' and @codeSystem = '2.16.840.1.113883.6.1')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:code[(@code = '80904-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:code[(@code = '80904-6' and @codeSystem = '2.16.840.1.113883.6.1')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:text) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Geburtsjahr des Patienten): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:value) &gt;= 1">(Geburtsjahr des Patienten): Element hl7:value ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:value) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:value kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Geburtsjahr des Patienten): Element hl7:effectiveTime ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']"
         id="d45e9276-false-d27825e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="string(@root) = ('1.2.276.0.76.3.1.195.10.9')">(Geburtsjahr des Patienten): Der Wert von root MUSS '1.2.276.0.76.3.1.195.10.9' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:code[(@code = '80904-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:code[(@code = '80904-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e9281-false-d27837e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="@nullFlavor or (@code='80904-6' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Birth year')">(Geburtsjahr des Patienten): Der Elementinhalt MUSS einer von 'code '80904-6' codeSystem '2.16.840.1.113883.6.1' displayName='Birth year'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:text
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:text"
         id="d45e9286-false-d27850e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Geburtsjahr des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:reference) &gt;= 1">(Geburtsjahr des Patienten): Element hl7:reference ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="count(hl7:reference) &lt;= 1">(Geburtsjahr des Patienten): Element hl7:reference kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:text/hl7:reference
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:text/hl7:reference"
         id="d45e9291-false-d27869e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Geburtsjahr des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:statusCode[@code = 'completed']
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:statusCode[@code = 'completed']"
         id="d45e9295-false-d27880e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="@nullFlavor or (@code='completed')">(Geburtsjahr des Patienten): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:value
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:value"
         id="d45e9300-false-d27893e0">
      <extends rule="INT"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(Geburtsjahr des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(Geburtsjahr des Patienten): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.9
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:effectiveTime
Item: (Geburtsjahr des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.9']]/hl7:effectiveTime"
         id="d45e9311-false-d27906e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Geburtsjahr des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.9-2024-08-13T113044.html"
              test="not(*)">(Geburtsjahr des Patienten): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
</pattern>
