<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.276.0.76.3.1.195.10.88
Name: Zeitpunkt Export aus EDIS
Description: Abgeleitete Informationen über Diagnostik zur Weitergabe - Zeitpunkt wann Datensatz aus dem EDIS an einen weiteren Datennutzer exportiert wurde
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000">
   <title>Zeitpunkt Export aus EDIS</title>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]"
         id="d45e9140-false-d27277e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]) &gt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]"
         id="d45e9146-false-d27294e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="string(@classCode) = ('OBS')">(Zeitpunkt Export aus EDIS): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="string(@moodCode) = ('EVN')">(Zeitpunkt Export aus EDIS): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']) &gt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:code[(@code = 'FLN-137' and @codeSystem = '1.2.276.0.76.3.1.195.5.98')]) &gt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:code[(@code = 'FLN-137' and @codeSystem = '1.2.276.0.76.3.1.195.5.98')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:code[(@code = 'FLN-137' and @codeSystem = '1.2.276.0.76.3.1.195.5.98')]) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:code[(@code = 'FLN-137' and @codeSystem = '1.2.276.0.76.3.1.195.5.98')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:text) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:value) &gt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:value ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:value) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:value kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']"
         id="d45e9152-false-d27358e0">
      <extends rule="II"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="string(@root) = ('1.2.276.0.76.3.1.195.10.88')">(Zeitpunkt Export aus EDIS): Der Wert von root MUSS '1.2.276.0.76.3.1.195.10.88' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:code[(@code = 'FLN-137' and @codeSystem = '1.2.276.0.76.3.1.195.5.98')]
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:code[(@code = 'FLN-137' and @codeSystem = '1.2.276.0.76.3.1.195.5.98')]"
         id="d45e9157-false-d27373e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="@nullFlavor or (@code='FLN-137' and @codeSystem='1.2.276.0.76.3.1.195.5.98' and @displayName='Zeitpunkt Export aus EDIS')">(Zeitpunkt Export aus EDIS): Der Elementinhalt MUSS einer von 'code 'FLN-137' codeSystem '1.2.276.0.76.3.1.195.5.98' displayName='Zeitpunkt Export aus EDIS'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:text
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:text"
         id="d45e9162-false-d27389e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:reference) &gt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:reference ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="count(hl7:reference) &lt;= 1">(Zeitpunkt Export aus EDIS): Element hl7:reference kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:text/hl7:reference
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:text/hl7:reference"
         id="d45e9167-false-d27408e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:statusCode[@code = 'completed']
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:statusCode[@code = 'completed']"
         id="d45e9171-false-d27419e0">
      <extends rule="CS"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="@nullFlavor or (@code='completed')">(Zeitpunkt Export aus EDIS): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:effectiveTime
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:effectiveTime"
         id="d45e9176-false-d27435e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="not(*)">(Zeitpunkt Export aus EDIS): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.88
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:value
Item: (Zeitpunkt Export aus EDIS)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.88']]/hl7:value"
         id="d45e9178-false-d27448e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Zeitpunkt Export aus EDIS): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.88-2024-05-24T000000.html"
              test="not(*)">(Zeitpunkt Export aus EDIS): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
</pattern>
