<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.276.0.76.3.1.195.10.8
Name: Alter des Patienten
Description: Alter des Patienten bei Stichtag, hier bei Aufnahme, berechnet (keine Benutzereingabe). 
                 Das Alter in Jahren ist in value Type PQ immer anzugeben, ebenso als value Typ CE in Kategorien. 
                 Das Alter in Tagen ist zusätzlich anzugeben bei Alter bis 120 Tage bzw. in Monaten bei Alter über 120 Tage and bis 2 Jahre.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015">
   <title>Alter des Patienten</title>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]
Item: (Alter des Patienten)
-->

   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]"
         id="d45e8701-false-d25525e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="string(@classCode) = ('OBS')">(Alter des Patienten): Der Wert von classCode MUSS 'OBS' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="string(@moodCode) = ('EVN')">(Alter des Patienten): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']) &gt;= 1">(Alter des Patienten): Element hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']) &lt;= 1">(Alter des Patienten): Element hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:code[(@code = '424144002' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(Alter des Patienten): Element hl7:code[(@code = '424144002' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:code[(@code = '424144002' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(Alter des Patienten): Element hl7:code[(@code = '424144002' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:text) &lt;= 1">(Alter des Patienten): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Alter des Patienten): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Alter des Patienten): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Alter des Patienten): Element hl7:effectiveTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:value[@xsi:type='PQ']) &gt;= 1">(Alter des Patienten): Element hl7:value[@xsi:type='PQ'] ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:value[@xsi:type='PQ']) &lt;= 1">(Alter des Patienten): Element hl7:value[@xsi:type='PQ'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:value[@xsi:type='CE']) &gt;= 1">(Alter des Patienten): Element hl7:value[@xsi:type='CE'] ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:value[@xsi:type='CE']) &lt;= 1">(Alter des Patienten): Element hl7:value[@xsi:type='CE'] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']"
         id="d45e8707-false-d25593e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="string(@root) = ('1.2.276.0.76.3.1.195.10.8')">(Alter des Patienten): Der Wert von root MUSS '1.2.276.0.76.3.1.195.10.8' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:code[(@code = '424144002' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:code[(@code = '424144002' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d45e8712-false-d25605e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="@nullFlavor or (@code='424144002' and @codeSystem='2.16.840.1.113883.6.96' and @displayName='Current chronological age (observable entity)')">(Alter des Patienten): Der Elementinhalt MUSS einer von 'code '424144002' codeSystem '2.16.840.1.113883.6.96' displayName='Current chronological age (observable entity)'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:text
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:text"
         id="d45e8717-false-d25618e0">
      <extends rule="ED"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Alter des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:reference) &gt;= 1">(Alter des Patienten): Element hl7:reference ist required [min 1x].</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:reference) &lt;= 1">(Alter des Patienten): Element hl7:reference kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:text/hl7:reference
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:text/hl7:reference"
         id="d45e8722-false-d25637e0">
      <extends rule="TEL"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Alter des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:statusCode[@code = 'completed']
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:statusCode[@code = 'completed']"
         id="d45e8726-false-d25648e0">
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="@nullFlavor or (@code='completed')">(Alter des Patienten): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:effectiveTime
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:effectiveTime"
         id="d45e8731-false-d25661e0">
      <extends rule="TS"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Alter des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="not(*)">(Alter des Patienten): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:value[@xsi:type='PQ']
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:value[@xsi:type='PQ']"
         id="d45e8737-false-d25672e0">
      <extends rule="PQ"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Alter des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Alter des Patienten): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Alter des Patienten): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="count(hl7:translation) &lt;= 1">(Alter des Patienten): Element hl7:translation kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:value[@xsi:type='PQ']/hl7:translation
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:value[@xsi:type='PQ']/hl7:translation"
         id="d45e8782-false-d25693e0">
      <extends rule="PQR"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQR')">(Alter des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQR" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.276.0.76.3.1.195.10.8
Context: *[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:value[@xsi:type='CE']
Item: (Alter des Patienten)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]]/hl7:observation[hl7:templateId[@root = '1.2.276.0.76.3.1.195.10.8']]/hl7:value[@xsi:type='CE']"
         id="d45e8785-false-d25701e0">
      <extends rule="CE"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Alter des Patienten): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="http://aktin.art-decor.pub/aktin-html-20251229T155034/tmp-1.2.276.0.76.3.1.195.10.8-2024-08-13T105015.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.276.0.76.3.1.195.11.9-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Alter des Patienten): Der Elementinhalt MUSS einer von '1.2.276.0.76.3.1.195.11.9 Alter in Kategorien (DYNAMIC)' sein.</assert>
   </rule>
</pattern>
